package com.nexgo.apiv3demo;

import android.app.Service;
import android.content.Context;
import android.media.AudioManager;

/**
 * 音量工具类
 */
public class VolumeUtil {
    private AudioManager mAudioManager;

    public VolumeUtil(){}

    public VolumeUtil(Context context){
        mAudioManager = (AudioManager) context.getSystemService(Service.AUDIO_SERVICE);
    }
    //Get maximum multimedia volume
    public int getMediaMaxVolume(){
        return mAudioManager.getStreamMaxVolume( AudioManager.STREAM_MUSIC );
    }
    //Get the current multimedia volume
    public int getMediaVolume(){
        return mAudioManager.getStreamVolume( AudioManager.STREAM_MUSIC );
    }

    //Get maximum call volume
    public int getCallMaxVolume(){
        return mAudioManager.getStreamMaxVolume( AudioManager.STREAM_VOICE_CALL );
    }

    //Get the current call volume
    public int getCallVolume(){
        return mAudioManager.getStreamVolume( AudioManager.STREAM_VOICE_CALL );
    }

    //Get maximum system volume
    public int getSystemMaxVolume(){

        return mAudioManager.getStreamMaxVolume(AudioManager.STREAM_SYSTEM );
    }

    //Get the current system volume
    public int getSystemVolume(){

        return mAudioManager.getStreamVolume(AudioManager.STREAM_SYSTEM );
    }

    //Get maximum prompt volume
    public int getAlermMaxVolume(){
        return mAudioManager.getStreamMaxVolume(AudioManager.STREAM_ALARM );
    }

    //Get the current prompt volume
    public int getAlermVolume(){
        return mAudioManager.getStreamVolume(AudioManager.STREAM_ALARM );
    }

    // Set multimedia volume
    public void setMediaVolume(int volume){
        mAudioManager.setStreamVolume(AudioManager.STREAM_MUSIC, //音量类型
                volume,
                AudioManager.FLAG_PLAY_SOUND
                        | AudioManager.FLAG_SHOW_UI);
    }

    //Set call volume
    public void setCallVolume(int volume){
        mAudioManager.setStreamVolume( AudioManager.STREAM_VOICE_CALL,
                volume,
                AudioManager.FLAG_PLAY_SOUND
                    | AudioManager.FLAG_SHOW_UI);
    }

    //Set prompt volume
    public void setAlermVolume(int volume){
        mAudioManager.setStreamVolume( AudioManager.STREAM_ALARM,
                volume,AudioManager.FLAG_PLAY_SOUND
                        |AudioManager.FLAG_SHOW_UI);
    }

    // Turn off/on speaker playback
    public void setSpeakerStatus(boolean on) {
        if (on) { //speaker
            mAudioManager.setSpeakerphoneOn(true);
            mAudioManager.setMode(AudioManager.MODE_NORMAL);
        } else {
            // Set maximum volume
            int max = mAudioManager.getStreamMaxVolume(AudioManager.STREAM_VOICE_CALL);
            mAudioManager.setStreamVolume(AudioManager.STREAM_VOICE_CALL, max, AudioManager.STREAM_VOICE_CALL);
            // Set to earpiece mode
            mAudioManager.setMode(AudioManager.MODE_IN_COMMUNICATION);
            mAudioManager.setSpeakerphoneOn(false);// Turn off the speaker
            mAudioManager.setRouting(AudioManager.MODE_NORMAL, AudioManager.ROUTE_EARPIECE, AudioManager.ROUTE_ALL);
        }
    }
}
